/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.client.GrassColorHandler;
import net.dries007.tfc.client.render.TESRAnvil;
import net.dries007.tfc.client.render.TESRBarrel;
import net.dries007.tfc.client.render.TESRBellows;
import net.dries007.tfc.client.render.TESRChestTFC;
import net.dries007.tfc.client.render.TESRCrucible;
import net.dries007.tfc.client.render.TESRFirePit;
import net.dries007.tfc.client.render.TESRIngotPile;
import net.dries007.tfc.client.render.TESRLoom;
import net.dries007.tfc.client.render.TESRPitKiln;
import net.dries007.tfc.client.render.TESRPlacedHide;
import net.dries007.tfc.client.render.TESRPlacedItem;
import net.dries007.tfc.client.render.TESRPlacedItemFlat;
import net.dries007.tfc.client.render.TESRQuern;
import net.dries007.tfc.client.render.TESRSluice;
import net.dries007.tfc.client.render.TESRToolRack;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.blocks.BlockPlacedHide;
import net.dries007.tfc.objects.blocks.BlockSlabTFC;
import net.dries007.tfc.objects.blocks.BlockThatchBed;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockFruitTreeLeaves;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.stone.BlockFarmlandTFC;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockSmooth;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.objects.items.ItemAnimalHide;
import net.dries007.tfc.objects.items.ItemGem;
import net.dries007.tfc.objects.items.ItemGoldPan;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.ceramics.ItemMold;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.objects.te.TEChestTFC;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.objects.te.TEIngotPile;
import net.dries007.tfc.objects.te.TELoom;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.objects.te.TEPlacedHide;
import net.dries007.tfc.objects.te.TEPlacedItem;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.objects.te.TEQuern;
import net.dries007.tfc.objects.te.TESluice;
import net.dries007.tfc.objects.te.TEToolRack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tfc")
public final class ClientRegisterEvents {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.WOODEN_BUCKET, (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.WOODEN_BUCKET.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.FIRED_JUG, (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.FIRED_JUG.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.BLUE_STEEL_BUCKET, (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.BLUE_STEEL_BUCKET.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.RED_STEEL_BUCKET, (int)0, (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.RED_STEEL_BUCKET.getRegistryName(), "inventory"));
        for (Item item : ItemsTFC.getAllSimpleItems()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString()));
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.UNFIRED_VESSEL_GLAZED, (int)color.func_176767_b(), (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.UNFIRED_VESSEL_GLAZED.getRegistryName().toString()));
            ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.FIRED_VESSEL_GLAZED, (int)color.func_176767_b(), (ModelResourceLocation)new ModelResourceLocation(ItemsTFC.FIRED_VESSEL_GLAZED.getRegistryName().toString()));
        }
        for (ItemGem item : ItemsTFC.getAllGemItems()) {
            Gem.Grade[] gradeArray = Gem.Grade.values();
            int color = gradeArray.length;
            for (int i = 0; i < color; ++i) {
                Enum grade = gradeArray[i];
                ClientRegisterEvents.registerEnumBasedMetaItems("gem", grade, item);
            }
        }
        for (ItemOreTFC item : ItemsTFC.getAllOreItems()) {
            if (item.ore.isGraded()) {
                for (Enum grade : Ore.Grade.values()) {
                    ClientRegisterEvents.registerEnumBasedMetaItems("ore", grade, item);
                }
                continue;
            }
            ClientRegisterEvents.registerEnumBasedMetaItems("ore", Ore.Grade.NORMAL, item);
        }
        ModelLoader.registerItemVariants((Item)ItemsTFC.GOLDPAN, (ResourceLocation[])((ResourceLocation[])Arrays.stream(ItemGoldPan.TYPES).map(e -> new ResourceLocation("tfc", "goldpan/" + e)).toArray(ResourceLocation[]::new)));
        for (int meta = 0; meta < ItemGoldPan.TYPES.length; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)ItemsTFC.GOLDPAN, (int)meta, (ModelResourceLocation)new ModelResourceLocation("tfc:goldpan/" + ItemGoldPan.TYPES[meta]));
        }
        ModelLoader.registerItemVariants((Item)ItemsTFC.GOLDPAN, (ResourceLocation[])((ResourceLocation[])Arrays.stream(ItemGoldPan.TYPES).map(e -> new ResourceLocation("tfc", "goldpan/" + e)).toArray(ResourceLocation[]::new)));
        ModelBakery.registerItemVariants((Item)ItemMold.get(Metal.ItemType.INGOT), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(ItemMold.get(Metal.ItemType.INGOT).getRegistryName() + "/unknown")});
        for (Metal.ItemType value : Metal.ItemType.values()) {
            final ItemMold item = ItemMold.get(value);
            if (item == null) continue;
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(item.getRegistryName().toString() + "/empty")});
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])((ResourceLocation[])TFCRegistries.METALS.getValuesCollection().stream().filter(value::hasMold).map(x -> new ModelResourceLocation(item.getRegistryName().toString() + "/" + x.getRegistryName().func_110623_a())).toArray(ModelResourceLocation[]::new)));
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){
                private final ModelResourceLocation FALLBACK;
                {
                    this.FALLBACK = new ModelResourceLocation(item.getRegistryName().toString() + "/empty");
                }

                @Nonnull
                public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                    Metal metal;
                    IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (cap instanceof IMoldHandler && (metal = ((IMoldHandler)cap).getMetal()) != null) {
                        return new ModelResourceLocation(stack.func_77973_b().getRegistryName() + "/" + metal.getRegistryName().func_110623_a());
                    }
                    return this.FALLBACK;
                }
            });
        }
        for (ItemBlock item : BlocksTFC.getAllNormalItemBlocks()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
        }
        for (ItemBlock item : BlocksTFC.getAllInventoryItemBlocks()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (ItemBlock item : BlocksTFC.getAllBarrelItemBlocks()) {
            ModelResourceLocation sealed = new ModelResourceLocation(item.getRegistryName(), "sealed=true");
            ModelResourceLocation unsealed = new ModelResourceLocation(item.getRegistryName(), "sealed=false");
            ModelLoader.setCustomMeshDefinition((Item)item, stack -> stack.func_77978_p() != null ? sealed : unsealed);
        }
        for (Block block : BlocksTFC.getAllFluidBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllFenceGateBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllLeafBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllOreBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockOreTFC.GRADE}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllWallBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockWall.field_176255_P}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllLogBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLogTFC.PLACED}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllSaplingBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSaplingTFC.STAGE}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllDoorBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllChestBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockChest.field_176459_a}).func_178441_a());
        }
        for (BlockSlabTFC.Half block : BlocksTFC.getAllSlabBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlabTFC.VARIANT}).func_178441_a());
            ModelLoader.setCustomStateMapper((Block)block.doubleSlab, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSlabTFC.VARIANT}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllCropBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockCropTFC.WILD}).func_178441_a());
        }
        for (Block block : BlocksTFC.getAllFruitTreeLeavesBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFruitTreeLeaves.field_176237_a}).func_178442_a(new IProperty[]{BlockFruitTreeLeaves.HARVESTABLE}).func_178441_a());
        }
        BlocksTFC.getAllBlockRockVariants().forEach(e -> {
            if (e.getType() == Rock.Type.FARMLAND) {
                ModelLoader.setCustomStateMapper((Block)e, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFarmlandTFC.MOISTURE}).func_178441_a());
            } else if (e.getType() == Rock.Type.RAW) {
                ModelLoader.setCustomStateMapper((Block)e, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRockRaw.CAN_FALL}).func_178441_a());
            } else if (e.getType() == Rock.Type.SMOOTH) {
                ModelLoader.setCustomStateMapper((Block)e, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRockSmooth.CAN_FALL}).func_178441_a());
            }
        });
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.THATCH_BED, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockThatchBed.field_176471_b}).func_178441_a());
        ModelResourceLocation empty = new ModelResourceLocation("tfc:empty");
        ModelResourceLocation hideRack = new ModelResourceLocation("tfc:hide_rack");
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.PIT_KILN, blockIn -> ImmutableMap.of((Object)BlocksTFC.PIT_KILN.func_176223_P(), (Object)empty));
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.PLACED_ITEM_FLAT, blockIn -> ImmutableMap.of((Object)BlocksTFC.PLACED_ITEM_FLAT.func_176223_P(), (Object)empty));
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.INGOT_PILE, blockIn -> ImmutableMap.of((Object)BlocksTFC.INGOT_PILE.func_176223_P(), (Object)empty));
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.PLACED_ITEM, blockIn -> ImmutableMap.of((Object)BlocksTFC.PLACED_ITEM.func_176223_P(), (Object)empty));
        ModelLoader.setCustomStateMapper((Block)BlocksTFC.PLACED_HIDE, blockIn -> ImmutableMap.of((Object)BlocksTFC.PLACED_HIDE.func_176223_P().func_177226_a(BlockPlacedHide.SIZE, (Comparable)((Object)ItemAnimalHide.HideSize.SMALL)), (Object)empty, (Object)BlocksTFC.PLACED_HIDE.func_176223_P().func_177226_a(BlockPlacedHide.SIZE, (Comparable)((Object)ItemAnimalHide.HideSize.MEDIUM)), (Object)empty, (Object)BlocksTFC.PLACED_HIDE.func_176223_P().func_177226_a(BlockPlacedHide.SIZE, (Comparable)((Object)ItemAnimalHide.HideSize.LARGE)), (Object)empty));
        ClientRegistry.bindTileEntitySpecialRenderer(TEChestTFC.class, (TileEntitySpecialRenderer)new TESRChestTFC());
        ClientRegistry.bindTileEntitySpecialRenderer(TEToolRack.class, (TileEntitySpecialRenderer)new TESRToolRack());
        ClientRegistry.bindTileEntitySpecialRenderer(TEPitKiln.class, (TileEntitySpecialRenderer)new TESRPitKiln());
        ClientRegistry.bindTileEntitySpecialRenderer(TEPlacedItemFlat.class, (TileEntitySpecialRenderer)new TESRPlacedItemFlat());
        ClientRegistry.bindTileEntitySpecialRenderer(TEPlacedItem.class, (TileEntitySpecialRenderer)new TESRPlacedItem());
        ClientRegistry.bindTileEntitySpecialRenderer(TEPlacedHide.class, (TileEntitySpecialRenderer)new TESRPlacedHide());
        ClientRegistry.bindTileEntitySpecialRenderer(TEIngotPile.class, (TileEntitySpecialRenderer)new TESRIngotPile());
        ClientRegistry.bindTileEntitySpecialRenderer(TEQuern.class, (TileEntitySpecialRenderer)new TESRQuern());
        ClientRegistry.bindTileEntitySpecialRenderer(TEBellows.class, (TileEntitySpecialRenderer)new TESRBellows());
        ClientRegistry.bindTileEntitySpecialRenderer(TEBarrel.class, (TileEntitySpecialRenderer)new TESRBarrel());
        ClientRegistry.bindTileEntitySpecialRenderer(TEAnvilTFC.class, (TileEntitySpecialRenderer)new TESRAnvil());
        ClientRegistry.bindTileEntitySpecialRenderer(TELoom.class, (TileEntitySpecialRenderer)new TESRLoom());
        ClientRegistry.bindTileEntitySpecialRenderer(TECrucible.class, (TileEntitySpecialRenderer)new TESRCrucible());
        ClientRegistry.bindTileEntitySpecialRenderer(TEFirePit.class, (TileEntitySpecialRenderer)new TESRFirePit());
        ClientRegistry.bindTileEntitySpecialRenderer(TESluice.class, (TileEntitySpecialRenderer)new TESRSluice());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerColorHandlerBlocks(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor grassColor = GrassColorHandler::computeGrassColor;
        IBlockColor foliageColor = GrassColorHandler::computeGrassColor;
        blockColors.func_186722_a(grassColor, new Block[]{BlocksTFC.PEAT_GRASS});
        blockColors.func_186722_a(grassColor, (Block[])BlocksTFC.getAllBlockRockVariants().stream().filter(x -> x.getType().isGrass).toArray(BlockRockVariant[]::new));
        blockColors.func_186722_a(grassColor, (Block[])BlocksTFC.getAllGrassBlocks().toArray((Object[])new BlockPlantTFC[0]));
        blockColors.func_186722_a(foliageColor, (Block[])BlocksTFC.getAllLeafBlocks().toArray((Object[])new Block[0]));
        blockColors.func_186722_a(foliageColor, (Block[])BlocksTFC.getAllPlantBlocks().toArray((Object[])new BlockPlantTFC[0]));
        blockColors.func_186722_a(foliageColor, (Block[])BlocksTFC.getAllFruitTreeLeavesBlocks().toArray((Object[])new Block[0]));
        blockColors.func_186722_a(foliageColor, (Block[])BlocksTFC.getAllFlowerPots().toArray((Object[])new Block[0]));
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> BlockFarmlandTFC.TINT[(Integer)state.func_177229_b((IProperty)BlockFarmlandTFC.MOISTURE)], (Block[])BlocksTFC.getAllBlockRockVariants().stream().filter(x -> x.getType() == Rock.Type.FARMLAND).toArray(BlockRockVariant[]::new));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerColorHandlerItems(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), (Block[])BlocksTFC.getAllBlockRockVariants().stream().filter(x -> x.getType().isGrass).toArray(BlockRockVariant[]::new));
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), new Block[]{BlocksTFC.PEAT_GRASS});
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), (Block[])BlocksTFC.getAllLeafBlocks().toArray((Object[])new BlockLeavesTFC[0]));
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), (Block[])BlocksTFC.getAllFruitTreeLeavesBlocks().toArray((Object[])new BlockFruitTreeLeaves[0]));
        itemColors.func_186730_a((stack, tintIndex) -> tintIndex == 1 ? EnumDyeColor.func_176766_a((int)stack.func_77952_i()).func_193350_e() : 0xFFFFFF, new Item[]{ItemsTFC.UNFIRED_VESSEL_GLAZED, ItemsTFC.FIRED_VESSEL_GLAZED});
        itemColors.func_186731_a((stack, tintIndex) -> event.getBlockColors().func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), (Block[])BlocksTFC.getAllGrassBlocks().toArray((Object[])new BlockPlantTFC[0]));
        itemColors.func_186730_a((stack, tintIndex) -> {
            IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (food != null) {
                return food.isRotten() ? ConfigTFC.Client.DISPLAY.rottenFoodOverlayColor : 0xFFFFFF;
            }
            return 0xFFFFFF;
        }, (Item[])ForgeRegistries.ITEMS.getValuesCollection().stream().filter(x -> x instanceof ItemFood).toArray(Item[]::new));
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerEnumBasedMetaItems(String prefix, Enum e, Item item) {
        String registryName = item.getRegistryName().func_110623_a();
        StringBuilder path = new StringBuilder("tfc").append(':');
        if (!Strings.isNullOrEmpty((String)prefix)) {
            path.append(prefix).append('/');
        }
        path.append(e.name());
        if (!Strings.isNullOrEmpty((String)prefix)) {
            path.append(registryName.replace(prefix, ""));
        } else {
            path.append('/').append(registryName);
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)e.ordinal(), (ModelResourceLocation)new ModelResourceLocation(path.toString().toLowerCase()));
    }
}

